// Created by inigo quilez - iq/2013
// License Creative Commons Attribution-NonCommercial-ShareAlike 3.0 Unported License.

// define this for higher quality nosie
//#define HQ_NOISE

// Uncomment the following for 3D!
//#define STEREO 

float2 R:TARGETSIZE;

Texture2D tex0 <string uiname="NoiseTexture";>;
Texture2D tex1 <string uiname="Texture";>;
SamplerState s0:IMMUTABLE
{
    Filter = MIN_MAG_MIP_LINEAR;
    AddressU = wrap;
    AddressV = wrap;
};

cbuffer cbPerDraw:register( b0 )
{
float4x4 tVP:VIEWPROJECTION;
float4x4 tW:WORLD;
float time;
};

float3 hash3( float n )
{
    return frac(sin(float3(n,n+1.0,n+2.0))*float3(43758.5453123,22578.1459123,19642.3490423));
}

float noise( in float3 x )
{
    float3 p = floor(x);
    float3 f = frac(x);
	f = f*f*(3.0-2.0*f);
	
#ifndef HQ_NOISE
	float2 uv = (p.xy+float2(37.0,17.0)*p.z) + f.xy;
	float2 rg = tex0.SampleLevel( s0, (uv+ 0.5)/256.0, -100.0 ).yx;
#else
	float2 uv = (p.xy+float2(37.0,17.0)*p.z);
	float2 rg = lerp( lerp( tex0.Sample( s0, (uv+ float2(0.5,0.5))/256.0, -100.0 ).yx,
				            tex0.SampleLevel( s0, (uv+ float2(1.5,0.5))/256.0, -100.0 ).yx, f.x ),
				      lerp( tex0.SampleLevel( s0, (uv+ float2(0.5,1.5))/256.0, -100.0 ).yx,
				            tex0.SampleLevel( s0, (uv+ float2(1.5,1.5))/256.0, -100.0 ).yx, f.x ), f.y );

#endif	
	return lerp( rg.x, rg.y, f.z );
}

//=====================================================

float3 texturize( Texture2D tex1, float3 p, float3 n )
{
	float3 x = tex1.Sample( s0, p.yz ).xyz;
	float3 y = tex1.Sample( s0, p.zx ).xyz;
	float3 z = tex1.Sample( s0, p.xy ).xyz;
	return x*abs(n.x) + y*abs(n.y) + z*abs(n.z);
}

//----------------------------------------------------------------


float2 map( float3 p )
{
	p.y -= 1.5;
	
	float3 q = p;

    float2 res = float2( 1e10, 0.0 );
	
	float it = floor( time/6.0 );
	float ft = frac( time/6.0 );
	float tt = it + 1.0 - pow(1.0-ft,5.0);
	float id = 0.0;
	for( int k=0; k<3; k++ )
	{
	    float3 off = -1.0*tt*sin( float(k)*float3(11.0,3.1,5.5)+float3(0.0,1.0,2.0));

		p.xz += 2.0*(-1.0 + 2.0*noise( p  + off));
		p.y += 0.2;

		float d = length( p ) - 1.8;

		if( d<res.x ) res=float2(d,1.0+float(k));
		
		p = p.yzx;
	}
	
	res.x *= 0.1*0.5;

	float di = sin(30.0*q.x)*sin(30.0*q.y)*sin(30.0*q.z);
	di = di*di;
	res.x += 0.005*di;

	return res;
}

float map2( in float3 p )
{
	return min( map(p).x, p.y );
}

float2 intersect( in float3 ro, in float3 rd )
{
	float maxd = 8.0;
	float2 res = float2(1e10,-1.0);

    // intersect ground plane	
	float tp = (0.0-ro.y)/rd.y;
    if( tp>0.0 ) {res = float2(tp,0.0), maxd=min(maxd,tp); }

    // intersect sculpture	
	float precis = 0.001;
    float h = 1.0;
    float t = 1.0;
    float m = -1.0;
    for( int i=0; i<256; i++ )
    {
        if( h<precis||t>maxd ) break;
	    float2 res = map( ro+rd*t );
        h = res.x;
		m = res.y;
        t += h;
    }
	if( t<maxd && t<res.x ) res=float2(t,m);

	return res;
}

float3 calcNormal( in float3 pos )
{
    float3 eps = float3(0.01,0.0,0.0);

	return normalize( float3(
           map(pos+eps.xyy).x - map(pos-eps.xyy).x,
           map(pos+eps.yxy).x - map(pos-eps.yxy).x,
           map(pos+eps.yyx).x - map(pos-eps.yyx).x ) );
}

float softshadow( in float3 ro, in float3 rd, float k )
{
    float res = 1.0;
    float t = 0.01;
	float h = 1.0;
    for( int i=0; i<64; i++ )
    {
        h = map(ro + rd*t).x;
        res = min( res, max(k*h/t,0.0) );
		t += clamp( h, 0.02, 0.1 );
		if( h<0.0001 ) break;
    }
    return clamp(res,0.0,1.0);
}

float calcAO( in float3 pos, in float3 nor, in float2 pix )
{
	float off = 0.1*dot( pix, float2(1.2,5.3) );
	float totao = 0.0;
    for( int aoi=0; aoi<16; aoi++ )
    {
		float3 aopos = -1.0+2.0*hash3(float(aoi)*213.47 + off);
		aopos = aopos*aopos*aopos;
		aopos *= sign( dot(aopos,nor) );
        float dd = clamp( map2( pos + nor*0.05 + aopos )*48.0, 0.0, 1.0 );
        totao += dd;
    }
	totao /= 16.0;
	
    return clamp( totao*totao*1.0, 0.0, 1.0 );
}

float3 lig = normalize(float3(0.8,0.4,0.2));


struct VS_IN
{
	float4 PosO:POSITION;
	float4 TexCd:TEXCOORD0;
};

struct vs2ps
{
    float4 PosWVP:SV_POSITION;
    float4 TexCd:TEXCOORD0;
};

vs2ps VS(VS_IN input)
{
    vs2ps output;
    output.PosWVP = mul(input.PosO,tW);
    output.TexCd = input.TexCd;
    return output;
}

float4 PS(vs2ps In) : SV_Target
{
    float2 q = In.TexCd.xy;
    float2 p = -1.0 + 2.0 * q;
    p.x *= R.x/R.y;
    float2 m = float(0.5);
	//if( iMouse.z>0.0 ) m = iMouse.xy/iResolution.xy;

	#ifdef STEREO
	float eyeID = mod(fragCoord.x + mod(fragCoord.y,2.0),2.0);
    #endif

    //-----------------------------------------------------
    // camera
    //-----------------------------------------------------
	
	float an = 10.5 + 0.12*time - 7.0*m.x;

	float3 ro = float3(4.5*sin(an),2.0,4.5*cos(an));
    float3 ta = float3(0.0,1.9,0.0);
    float cr = 0.2*cos(0.1*an);
    // camera matrix
    float3 ww = normalize( ta - ro );
    float3 uu = normalize( cross(ww,float3(sin(cr),cos(cr),0.0) ) );
    float3 vv = normalize( cross(uu,ww));
	// create view ray
	float3 rd = normalize( p.x*uu + p.y*vv + 1.5*ww );

	#ifdef STEREO
	float3 fo = ro + rd*7.0; // put focus plane behind Mike
	ro -= 0.1*uu*eyeID;    // eye separation
	rd = normalize(fo-ro);
    #endif

    //-----------------------------------------------------
	// render
    //-----------------------------------------------------
    float sun = clamp( dot(rd,lig), 0.0, 1.0 );
	float3 bg = lerp( 0.6*float3(0.98,0.99,0.8), 0.8*float3(0.8,0.6,0.3), pow(1.0-max(0.0,rd.y),4.0) );
	float3 col = bg;
	col += float3(1.0,0.8,0.4)*1.0*pow( sun, 50.0 );

	// raymarch
    float2 tmat = intersect(ro,rd);
    if( tmat.y>-0.5 )
    {
        // geometry
        float3 pos = ro + tmat.x*rd;
        float3 nor = calcNormal(pos);
		float3 ref = reflect( rd, nor );
        float3 tex = float(0.0);
		
        float di = sin(30.0*pos.x)*sin(30.0*(pos.y-1.5))*sin(30.0*pos.z);

        // materials
		float4 mate = float(0.0);
		float2 mate2 = float2(0.0,1.0);
		if( tmat.y<0.5 )
		{
			mate.xyz = float3(0.5,0.3,0.1);
			mate.xyz = 1.2*float3(0.8,0.65,0.2);
			
			mate2.x = 1.0;
            mate2.y = 1.0 - 0.75*(5.0/(5.0+dot(pos.xz,pos.xz)));
			nor = float3(0.0,1.0,0.0);
			
			tex = tex1.Sample( s0, pos.xz*0.15 ).xyz;
		    mate.xyz *= tex;
			
		}
		else
		{
            mate2.x = 1.0;
			mate = float4(0.3,0.3,0.3,0.8);
			mate.xyz = 0.5 + 0.5*cos( tmat.y*float(1.0) + 2.0 + float3(0.0,0.5,0.8) );
			
		    tex = texturize( tex1, 0.2*pos*float3(1.0,4.0,1.0), nor ).xyz;
		    mate.xyz *= tex.xyz;

		    mate.xyz = lerp( mate.xyz, float3(0.2,0.2,0.1)*0.5, 0.6*smoothstep(0.0,1.0,nor.y) );
			
			float hh = sin(30.0*pos.y);
			
			mate.xyz += 0.1*(1.0-smoothstep(-0.8,-0.5,hh))*(1.0-clamp((tmat.y-1.0)*4.0,0.0,1.0));
            mate2.y *= 1.0-0.85*di*di;		
			
		}

		// lighting
		float occ = mate2.y  * calcAO( pos, nor, In.TexCd );
		
		
        float sky = 0.6 + 0.4*nor.y;
		float bou = clamp(-nor.y,0.0,1.0)*1.0*clamp(1.0-pos.y/8.0,0.0,1.0);
		float dif = max(dot(nor,lig),0.0);
        float bac = max(0.3 + 0.7*dot(nor,normalize(float3(-lig.x,0.0,-lig.z))),0.0);
		float sha = 0.0; if( dif>0.01 ) sha=softshadow( pos+0.01*nor, lig, 256.0 );
        float fre = pow( clamp( 1.0 + dot(nor,rd), 0.0, 1.0 ), 2.0 );
        float spe = tex.x*max( 0.0, pow( clamp( dot(lig,reflect(rd,nor)), 0.0, 1.0), mate2.x*tex.x*2.0 ) );

		// lights
		float3 lin  = 2.9*dif*float3(1.0,0.90,0.70)*sha*(0.8+0.2*occ);
		     lin += 0.6*bac*float3(0.5,0.40,0.25)*occ;
		     lin += 0.6*sky*float3(0.6,1.00,1.50)*occ;
		     lin += 0.6*bou*float3(0.5,0.45,0.25)*occ;
             lin += 0.6*fre*float3(1.0,0.95,0.70)*2.0*mate.w*(0.1+0.9*occ*dif*sha);
             lin += 4.0*spe*float3(1.0,1.00,1.00)*occ*(0.2+0.8*fre);
		
		// surface-light interacion
		col = mate.xyz * lin;
		col += pow(spe,8.0)*0.25*sha*occ;
		
		col = lerp( col, bg, 1.0-exp(-0.002*tmat.x*tmat.x) );
	}

	// sun glow
    col += float3(1.0,0.6,0.2)*0.15*pow( sun, 4.0 );

	
	//-----------------------------------------------------
	// postprocessing
    //-----------------------------------------------------
    // gamma
	col = pow( clamp(col,0.0,1.0), float(0.45) );
	// contrast
	col = col*0.6 + 0.4*col*col*(3.0-2.0*col);

	// vigneting
    col *= 0.5 + 0.5*pow( abs(16.0*q.x*q.y*(1.0-q.x)*(1.0-q.y)), 0.1 );

    #ifdef STEREO	
    col *= float3( eyeID, 1.0-eyeID, 1.0-eyeID );	
	#endif

    return float4 ( col, 1.0 );

}


technique10 Sculpture_I
{
	pass P0
	{
		SetVertexShader(CompileShader(vs_4_0,VS()));
		SetPixelShader(CompileShader(ps_4_0,PS()));
	
	}
}



